import http from '../http'
import { https } from '../https'

export default {
  pageAllocate: data =>
    http
      .post(
        '/v1/item/page-allocate?sampleIds=' + data.sampleIds,
        JSON.stringify(data.obj)
      )
      .then(res => res),

  pageDispatch: data =>
    http
      .post(
        '/v1/item/page-dispatch?sampleIds=' + data.sampleIds,
        JSON.stringify(data.obj)
      )
      .then(res => res),

  pageItemVO: data => http.post('/v1/item/page-vo', data).then(res => res),

  pageOkItem: data => http.post('/v1/item/page-ok-vo', data).then(res => res),

  pageNotOkItem: data =>
    http.post('/v1/item/page-not-ok-vo', data).then(res => res),

  pageItemInput: data =>
    http.post('/v1/item/page-input', data).then(res => res),

  pageItemInputEnv: data =>
    http.post('/v1/item/page-input-env', data).then(res => res),

  pageInputEnvHis: data =>
    http.post('/v1/item/page-input-env-his', data).then(res => res),

  pageInputHis: data =>
    http.post('/v1/item/page-input-his', data).then(res => res),
  pageItemCheck: data =>
    http
      .post('/v1/item/page-check?sampleIds=' + data.sampleIds, data.obj)
      .then(res => res),
  pageItemCheckHis: data =>
    http.post('/v1/item/page-check-his', data).then(res => res),

  pageItemCheckEnv: data =>
    http.post('/v1/item/page-check-env', data).then(res => res),

  pageItemCheckEnvHis: data =>
    http.post('/v1/item/page-check-env-his', data).then(res => res),

  pageItemAuditEnvHis: data =>
    http.post('/v1/item/page-audit-env-his', data).then(res => res),

  pageItemAudit: data =>
    http
      .post('/v1/item/page-audit?sampleIds=' + data.sampleIds, data.obj)
      .then(res => res),
  pageItemAuditEnv: data =>
    http.post('/v1/item/page-audit-env', data).then(res => res),
  pageItemAuditHis: data =>
    http.post('/v1/item/page-audit-his', data).then(res => res),
  getById: id => http.get('/v1/test_catalogue/' + id).then(res => res),
  edit: data => http.post('/v1/item/edit', data).then(res => res),
  add: data => http.post('/v1/sample/', data).then(res => res),
  submitCheck: data =>
    http.post('/v1/item/submit-check?ids=' + data).then(res => res),
  submitCheckEnv: data =>
    http.post('/v1/item/submit-check-env?ids=' + data).then(res => res),

  submitAudit: data =>
    http.post('/v1/item/submit-audit?ids=' + data).then(res => res),

  submitAuditEnv: data =>
    http.post('/v1/item/submit-audit-env?ids=' + data).then(res => res),

  bathConfirmItem: data =>
    http.post('/v1/item/bath-confirm-item?itemIds=' + data).then(res => res),

  bathConfirmItemEnv: data =>
    http
      .post('/v1/item/bath-confirm-item-env?itemIds=' + data)
      .then(res => res),

  testValue: data =>
    http
      .post('/v1/item/bath-write-value/' + data.itemIds, data)
      .then(res => res),
  allocateItem: data =>
    http
      .post('/v1/item/allocate-item?ids=' + data.ids, data.obj)
      .then(res => res),

  handJudge: data =>
    http.post('/v1/item/hand_judge?ids=' + data.itemIds, data).then(res => res),

  adjustTester: data =>
    http
      .post('/v1/item/adjust-tester?ids=' + data.ids, data.obj)
      .then(res => res),
  // 驳回
  backCheck: data =>
    http.post('/v1/item/back_check?itemIds=' + data.ids, data).then(res => res),

  backCheckEnv: data =>
    http
      .post('/v1/item/back_check_env?itemIds=' + data.ids, data)
      .then(res => res),

  backAudit: data =>
    http.post('/v1/item/back_audit?itemIds=' + data.ids, data).then(res => res),
  backAuditEnv: data =>
    http
      .post('/v1/item/back_audit_env?itemIds=' + data.ids, data)
      .then(res => res),
  bathAddEquip: data =>
    https.post('/v1/item/bath-add-equip', JSON.stringify(data)).then(res => res)
}
