import http from '../http'

export default {
  pageItemRecord: data =>
    http.post('/v1/item_record/page', data).then(res => res),

  pageSampleRecord: data =>
    http.post('/v1/sample_record/page', data).then(res => res),

  pageItemInput: data =>
    http.post('/v1/item/page-input', data).then(res => res),
  pageInputHis: data =>
    http.post('/v1/item/page-input-his', data).then(res => res),

  pageItemCheck: data =>
    http.post('/v1/item/page-check', data).then(res => res),

  pageItemCheckHis: data =>
    http.post('/v1/item/page-check-his', data).then(res => res),
  pageItemAudit: data =>
    http.post('/v1/item/page-audit', data).then(res => res),
  pageItemAuditHis: data =>
    http.post('/v1/item/page-audit-his', data).then(res => res),
  getById: id => http.get('/v1/test_catalogue/' + id).then(res => res),
  edit: data =>
    http.put('/v1/test_catalogue?id=' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/sample/', data).then(res => res),
  submitCheck: data =>
    http.post('/v1/item/submit-check?ids=' + data).then(res => res),
  submitAudit: data =>
    http.post('/v1/item/submit-audit?ids=' + data).then(res => res),

  bathConfirmItem: data =>
    http.post('/v1/item/bath-confirm-item?itemIds=' + data).then(res => res),
  testValue: data =>
    http
      .post('/v1/item/bath-write-value/' + data.itemIds, data)
      .then(res => res),
  allocateItem: data =>
    http
      .post('/v1/item/allocate-item?ids=' + data.ids, data.obj)
      .then(res => res),

  handJudge: data =>
    http.post('/v1/item/hand_judge?ids=' + data.itemIds, data).then(res => res),

  adjustTester: data =>
    http
      .post('/v1/item/adjust-tester?ids=' + data.ids, data.obj)
      .then(res => res),
  // 驳回
  backCheck: data =>
    http.post('/v1/item/back_check?itemIds=' + data.ids, data).then(res => res),

  backAudit: data =>
    http.post('/v1/item/back_audit?itemIds=' + data.ids, data).then(res => res)
}
