import http from '../http'

export default {
  page: data =>
    http.post('/v1/frame_customer_investigate/page', data).then(res => res),
  deleteById: id =>
    http.delete('/v1/frame_customer_investigate/' + id).then(res => res),
  getById: id =>
    http.get('/v1/frame_customer_investigate/' + id).then(res => res),
  edit: data =>
    http
      .put('/v1/frame_customer_investigate/' + data.id, data.obj)
      .then(res => res),
  add: data =>
    http.post('/v1/frame_customer_investigate/', data).then(res => res),
  submitById: data =>
    http
      .post('/v1/frame_customer_investigate/submit_batch?ids=' + data)
      .then(res => res),
  approve: data =>
    http
      .post('/v1/frame_customer_investigate/approve/' + data.taskId, data)
      .then(res => res)
}
