import http from '../http'

export default {
  page: data =>
    http.post('/v1/qc_main_plan/page_main_plan', data).then(res => res),
  pageRecord: data =>
    http.post('/v1/qc_main_plan/page_main_record', data).then(res => res),
  deleteById: id => http.delete('/v1/qc_main_plan/' + id).then(res => res),
  getById: id => http.get('/v1/qc_main_plan/' + id).then(res => res),
  edit: data =>
    http.put('/v1/qc_main_plan/' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/qc_main_plan/', data).then(res => res),
  submitById: data =>
    http.post('/v1/qc_main_plan/submit_flow?ids=' + data).then(res => res),
  approve: data =>
    http.post('/v1/qc_main_plan/approve/' + data.taskId, data).then(res => res),
  approveCheck: data =>
    http
      .post(
        '/v1/qc_main_plan/approve/' +
          data.id +
          '?reason=' +
          data.reason +
          '&status=' +
          data.status
      )
      .then(res => res)
}
