import http from '../http'

export default {
  page: data =>
    http.post('/v1/qc_sub_plan/page_sub_plan', data).then(res => res),
  pageRecord: data =>
    http.post('/v1/qc_sub_plan/page_record', data).then(res => res),
  deleteById: id => http.delete('/v1/qc_sub_plan/' + id).then(res => res),
  getById: id => http.get('/v1/qc_sub_plan/' + id).then(res => res),
  edit: data =>
    http.put('/v1/qc_sub_plan/' + data.id, data.obj).then(res => res),
  add: data => http.post('/v1/qc_sub_plan/', data).then(res => res),
  submitById: data =>
    http.post('/v1/qc_sub_plan/submit_flow?ids=' + data).then(res => res),
  approve: data =>
    http.post('/v1/qc_sub_plan/approve/' + data.taskId, data).then(res => res)
}
