/**
 * 黑名单信息相关
 */
import http from '../http'

export default {
  page: data => http.post('/message/v1/black_list/page', data).then(res => res),
  add: data => http.post('/message/v1/black_list/', data).then(res => res),
  edit: data =>
    http.put('/message/v1/black_list/' + data.id, data.obj).then(res => res),
  deleteByIds: ids =>
    http.delete('/message/v1/black_list/?ids=' + ids).then(res => res),
  getById: id => http.get('/message/v1/black_list/' + id).then(res => res),
  open: ids =>
    http.post('/message/v1/black_list/open/?ids=' + ids).then(res => res),
  deny: ids =>
    http.post('/message/v1/black_list/deny/?ids=' + ids).then(res => res)
}
