/**
 * 编号规则相关
 */

import http from '../http'

export default {
  // page
  page: data => http.post('/v1/code_rule/page', data).then(res => res),
  add: data => http.post('/v1/code_rule/', data).then(res => res),
  login: data => http.post('/v1/auth/login', data).then(res => res),
  edit: data => http.put('/v1/code_rule/' + data.id, data.obj).then(res => res),
  getById: data => http.get('/v1/code_rule/' + data).then(res => res),
  ruleRecord: data =>
    http.post('/v1/code_rule/page_rule_record', data).then(res => res),
  editRuleRecord: data =>
    http.put('/v1/code_rule/record_' + data.id, data).then(res => res)
}
