/**
 * 相关
 */
import http from '../http'
import { https } from '../https'

export default {
  getById: id => http.get('/v1/equip_check/' + id).then(res => res),
  getVOById: id => http.get('/v1/equip_check/vo/' + id).then(res => res),
  getTemp: id => http.get('/v1/equip_check/getTemp/').then(res => res),
  pageDetails: data =>
    http.post('/v1/equip_check/page_details', data).then(res => res),
  approve: data =>
    http.post('/v1/equip_check/approve/' + data.id, data).then(res => res),
  addDetail: data =>
    http
      .post('/v1/equip_check/addDetail/?equipIds=' + data.equipIds, data.obj)
      .then(res => res),
  add: data => http.post('/v1/equip_check/add', data).then(res => res),
  edit: data =>
    https.put('/v1/equip_check/', JSON.stringify(data)).then(res => res),
  addDo: data =>
    https.post('/v1/equip_check/add/', JSON.stringify(data)).then(res => res)
}
