/**
 * 仪器报废信息表相关
 */
import http from '../http'

export default {
  page: data => http.post('/v1/equip_scrap/page_vo', data).then(res => res),
  getById: id => http.get('/v1/equip_scrap/vo/' + id).then(res => res),
  add: data => http.post('/v1/equip_scrap/', data).then(res => res),
  approve: data =>
    http.post('/v1/equip_scrap/approve/' + data.id, data).then(res => res),
  getTemp: data => http.get('/v1/equip_scrap/getTemp/').then(res => res),
  pageManage: data =>
    http.post('/v1/equip_scrap/page_manage', data).then(res => res),
  addDetail: data =>
    http
      .post('/v1/equip_scrap/addDetail/?equipIds=' + data.equipIds, data.obj)
      .then(res => res),
  // 详情新增
  equipScrapDetailAdd: data =>
    http
      .post('/v1/equip_scrap/addDetail/?equipIds=' + data.equipIds, data.obj)
      .then(res => res),
  deleteFile: data =>
    http
      .delete(
        '/v1/equip_scrap/deleteFile/' +
          data.id +
          '/' +
          data.type +
          '/' +
          data.scrapId
      )
      .then(res => res)
}
