/**
 * 自定义表单相关
 */

import http from '../http'

export default {
  // 根据按钮 code 获取相关表单
  getByBtnCode: id => http.post('/base/v1/form/list_' + id).then(res => res),
  page: data => http.post('/base/v1/form/page', data).then(res => res),
  pageVO: data => http.post('/base/v1/form/page_vo', data).then(res => res),
  list: data => http.post('/base/v1/form/list', data).then(res => res),
  add: data => http.post('/base/v1/form/', data).then(res => res),
  edit: data => http.put('/base/v1/form/' + data.id, data.obj).then(res => res),
  getById: id => http.get('/base/v1/form/' + id).then(res => res),
  deleteById: id => http.delete('/base/v1/form/' + id).then(res => res)
}
