/**
 * 模块表相关
 */
import http from '../http'

export default {
  page: data => http.post('/base/v1/module/page', data).then(res => res),
  add: data => http.post('/base/v1/module/', data).then(res => res),
  edit: data =>
    http.put('/base/v1/module/' + data.id, data.obj).then(res => res),
  listCompanyId: data =>
    http
      .post('/base/v1/module/list_' + data.companyId + '_' + data.systemId)
      .then(res => res),
  listBySystemId: data =>
    http.post('/base/v1/module/list_user_' + data).then(res => res),
  addModule: data =>
    http.post('/base/v1/module/rel_user/' + data).then(res => res),
  deleteModule: data =>
    http.delete('/base/v1/module/rel_user_module/' + data).then(res => res),
  getById: id => http.get('/base/v1/module/' + id).then(res => res),
  editSort: data =>
    http
      .put('/base/v1/module/user_sort_' + data.id + '?sort=' + data.sort)
      .then(res => res)
}
