/**
 * 角色表
 */

import http from '../http'

export default {
  page: data => http.post('/v1/role/page', data).then(res => res),
  add: data => http.post('/v1/role/', data).then(res => res),
  edit: data => http.put('/v1/role/' + data.id, data.obj).then(res => res),
  getById: id => http.get('/v1/role/vo_' + id).then(res => res),
  assignMenu: data =>
    http
      .post('/v1/role/rel-resource/' + data.id, {
        resourceIds: JSON.stringify(data.idsList)
      })
      .then(res => res),
  proSelectIds: data =>
    http.get('/v1/role/get-rel-resource/' + data).then(res => res),
  // 角色tree
  roleTreeList: data => http.post('/v1/role/role-tree', data).then(res => res)
}
