/**
 * 用户管理
 */

import http from '../http'

export default {
  // page
  page: data => http.post('/v1/user/page', data).then(res => res),
  add: data => http.post('/v1/user/', data).then(res => res),
  edit: data => http.put('/v1/user/' + data.id, data.obj).then(res => res),
  getById: data => http.get('/v1/user/' + data).then(res => res),
  list: data => http.post('/v1/user/list', data).then(res => res),
  pageFlowMemberShip: data =>
    http
      .post('/v1/user/page-flow-member-ship/' + data.groupId, data)
      .then(res => res),
  pageNotSendMessage: data =>
    http
      .post('/v1/user/page-not-send-message/' + data.messageId, data)
      .then(res => res),
  pageFlowExcludeMemberShip: data =>
    http
      .post('/v1/user/page-flow-exclude-member-ship/' + data.groupId, data)
      .then(res => res),
  // 添加、编辑管理员
  addManager: data =>
    http.post('/v1/user/manager/' + data.companyId, data).then(res => res),
  // 提交ids
  roleTreeIds: data =>
    http
      .post('/v1/user/rel-role/' + data.id + '?roleIds=' + data.idsList)
      .then(res => res),
  // 查找ids
  roleSelectIds: data =>
    http.get('/v1/user/get-rel-role/' + data).then(res => res),
  // 管理员信息查询
  managerInfo: data =>
    http.post('/v1/user/manager-info/' + data).then(res => res),
  // 用户信息查询
  getUserInfo: data => http.get('/v1/user/info').then(res => res),
  // 用户修改密码
  editPsd: data => http.put('/v1/user/password', data).then(res => res),
  // 查找ids
  orginSelectIds: data =>
    http.get('/v1/user/get-rel-org/' + data).then(res => res),
  pageByOrgId: data =>
    http.post('/v1/user/page-org/' + data.orgId, data.realname).then(res => res)
}
