// https://pm2.io/doc/en/runtime/quick-start/
// 启动、指定测试环境 --env testing
// pm2 start ecosystem.config.js --env testing
// 重启  --update-env
// pm2 restart ecosystem.config.js --env testing --update-env
module.exports = {
  apps: [
    {
      name: 'pt-tobacco',
      script: './node_modules/nuxt-start/bin/nuxt-start.js',
      instances: 2,
      max_memory_restart: '512M',
      exec_mode: 'cluster',
      output: './out.log',
      error: './error.log',
      log: './combined.outerr.log',
      watch: ['server', 'client'],
      watch_delay: 1000,
      ignore_watch: ['node_modules'],
      env: {
        NODE_ENV: 'production'
      },
      env_testing: {
        NODE_ENV: 'testing'
      }
    }
  ]
}
