import Store from 'store2'
// 引入nprogress
import NProgress from 'nprogress'
import 'nprogress/nprogress.css'
// Nprogress的基本配置
NProgress.inc(0.2)
NProgress.configure({ easing: 'ease', speed: 500, showSpinner: false })

export default ({ app }) => {
  app.router.beforeEach((to, from, next) => {
    // console.log('to==', to)
    // console.log('from==', from)
    NProgress.start()
    const isLock = Store.session('isLock')
    if (isLock && to.path !== '/lock') {
      next({
        path: '/lock'
      })
    } else {
      Store.session('formPath', from.path)
      next()
    }
  })
  app.router.afterEach(() => {
    NProgress.done()
  })
}
