/**
 * 抽样计划表相关
 */
import http from '../http'

export default {
    page: data => http.post('/drs/v1/sampling_plan/page', data).then(res => res),
    pageApp: data => http.post('/drs/v1/sampling_plan/page_app', data).then(res => res),
    acceptFinish: data => http.post('/drs/v1/sampling_plan/accept_or_finish_task', data).then(res => res),

    getById: id => http.get('/drs/v1/sampling_plan/' + id).then(res => res),

    savePlace:data=>http.post('/drs/v1/sampling_plan/save_place_random', data).then(res=>res),


    add:data=>http.post('/drs/v1/sampling_plan/', data).then(res=>res),
    addPlan:data=>http.post('/drs/v1/sampling_plan/add_plan', data).then(res=>res),
    edit:data=>http.put('/drs/v1/sampling_plan/' + data.id, data.obj).then(res=>res),
    deleteByIds:ids=>http.delete('/drs/v1/sampling_plan/?ids=' + ids).then(res=>res),

    generatePlace:data=>http.post('/drs/v1/sampling_plan/generate_place_random', data).then(res=>res),
    generateSampler:data=>http.post('/drs/v1/sampling_plan/generate_sampler_random', data).then(res=>res),

    saveSamplerRandom:data=>http.post('/drs/v1/sampling_plan/save_sampler_random', data).then(res=>res),
    submit:data=>http.post('/drs/v1/sampling_plan/submit_plan', data).then(res=>res),
    planApprove:data=>http.post('/drs/v1/sampling_plan/plan_approve', data).then(res=>res),
    samplerPage:data=>http.post('/drs/v1/sampling_plan/search_plan_sampler', data).then(res=>res),
    saveSampler:data=>http.post('/drs/v1/sampling_plan/save_plan_sampler', data).then(res=>res),
    deletePlanSampler:data=>http.post('/drs/v1/sampling_plan/delete_plan_sampler', data).then(res=>res),
    saveSubmitPlan:data=>http.post('/drs/v1/sampling_plan/save_submit_plan', data).then(res=>res),
    submitPlanApp:data=>http.post('/drs/v1/sampling_plan/submit_plan_app', data).then(res=>res),
    getSamplerPlace:data=>http.post('/drs/v1/sampling_plan/search_selected_sampler_place', data).then(res=>res),
    searchModelCount:data=>http.post('/drs/v1/sampling_plan/search_model_count', data).then(res=>res),
}
