import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'

import plugins from './lib/plugins'
Vue.use(plugins)

// import Navigation from 'vue-navigation'
// Vue.use(Navigation, {router});

import Vue2TouchEvents from 'vue2-touch-events'
Vue.use(Vue2TouchEvents)

import Vant from 'vant';
import 'vant/lib/index.css';
Vue.use(Vant);

import ViewUI from 'view-design';
import 'view-design/dist/styles/iview.css';
Vue.use(ViewUI);

import '@/styles/main.less'

import SearchBar from '@/components/SearchBar.vue'
import DatetimeField from '@/components/DatetimeField.vue'
import PickerField from '@/components/PickerField.vue'
import ConfirmDialog from '@/components/ConfirmDialog.vue'
import CustomerNavBarLayout from '@/layout/CustomerNavBarLayout.vue'

Vue.component('search-bar', SearchBar)
Vue.component('datetime-field', DatetimeField)
Vue.component('picker-field', PickerField)
Vue.component('confirm-dialog', ConfirmDialog)
Vue.component('customer-navBar-layout', CustomerNavBarLayout)


Vue.config.productionTip = false

new Vue({
    router,
    store,
    render: h => h(App),
}).$mount('#app')
