/**
 * 双随机抽样货架表相关
 */
import http from '../../api/http'
import httpJson from '../../api/httpJson'

export default {
    page: data => http.post('/drs/v1/sampling_summary/page', data).then(res => res),
    add: data => httpJson.post('/drs/v1/sampling_summary/', JSON.stringify(data)).then(res => res),
    edit: data => httpJson.post('/drs/v1/sampling_summary/edit',JSON.stringify(data)).then(res => res),
    deleteByIds: ids => http.delete('/drs/v1/sampling_summary/?ids=' + ids).then(res => res),
    getById: id => http.get('/drs/v1/sampling_summary/' + id).then(res => res),
    lastTester: () => http.post('/drs/v1/sampling_summary/last_tester').then(res => res),
    getTester: data => http.post('/drs/v1/sampling_summary/get_tester_by_name',data).then(res => res),
    getProducter: data => http.post('/drs/v1/sampling_summary/get_producter_by_name',data).then(res => res),
    checkShelfDelete: data => http.post('/drs/v1/sampling_summary/check_shelf_delete',data).then(res => res),
}
