import Vue from 'vue'
import VueRouter from 'vue-router'
import routes from './routes'
import global from '@/api/config'

Vue.use(VueRouter)

const router = new VueRouter({
    routes // (缩写) 相当于 routes: routes
})

router.beforeEach((to, _from, next) => {
    if(to.path === '/login'){
        next()
    }else{
        if(global.getToken()){
            next()
        }else{
            next({path: '/login'})
        }
    }
})

router.afterEach(() => {
    // console.log(to, from)
    // LoadingBar.finish();
})


export default router
