const path = require('path')

function resolve(dir) {
    return path.join(__dirname, dir)
}

module.exports = {
    publicPath: "./",
    devServer: {
        host: '0.0.0.0',
        port: 8080,
        open: false,
    },
    configureWebpack: {
        externals: {
            'BMap': 'BMap'
        }
    },
    css: {
        loaderOptions: {
            less: {
                // 若使用 less-loader@5，请移除 lessOptions 这一级，直接配置选项。
                lessOptions: {
                    modifyVars: {
                        // 直接覆盖变量  优先级最高
                        // 'text-color': '#00a0e9',
                        // 'border-color': '#00ff00',
                        // 'nav-bar-background-color': '#00a0e9',
                        // 'nav-bar-icon-color': '#ffffff',
                        // 'nav-bar-text-color': ' #ffffff',
                        // 或者可以通过 less 文件覆盖（文件路径为绝对路径）
                        // hack: `true; @import "${resolve('./src/styles/resetVar.less')}";`,
                    },
                },
            },
        },
    },
}
