import Index from '@/page/Index'
import Home from '@/page/Home'
import Login from '@/page/Login'
import ForgetPwd from '@/page/ForgetPwd'
import Message from '@/page/Message'
import FlowChart from '@/page/FlowChart'
import SamplingPlanRoutes from './sampling-plan-routes'
import SamplingTaskRoutes from './sampling-task-routes'
import SamplingListRoutes from './sampling-list-routes'
import HistorySamplingRoutes from './history-sampling-routes'
import MineRoutes from './mine-routes'


import DebugComponent from '@/components/DebugComponent.vue'

export default [
    {
        path: '/', component: Index, redirect: '/home', children: [
            {
                path: "/home",
                name: "home",
                component: Home,
                meta: {title: "双随机抽样", leftArrow: false},
            },
            {
                path: "/login",
                name: "login",
                component: Login,
                meta: {title: "登录", hideNavBar: true},
            }, {
                path: "/forget_pwd",
                name: "forgetPwd",
                component: ForgetPwd,
                meta: {title: "找回密码", hideNavBar: true},
            }, {
                path: "/debug",
                name: "debug",
                component: DebugComponent,
                meta: {title: "调试组件页面", hideNavBar: true},
            }, {
                path: "/message",
                name: 'message',
                component: Message,
                meta: {title: '我的消息'}
            },{
                path: "/flow_chart",
                name: 'flowChart',
                component: FlowChart,
                meta: {title: '流程'}
            }

        ],
    }, {
        path: '/mine',
        component: Index,
        children: MineRoutes,
        mata: {title: '个人中心'}
    },
    {
        path: '/sampling_plan',
        component: Index,
        children: SamplingPlanRoutes,
        mata: {title: '抽样计划'}
    }, {
        path: '/sampling_task',
        component: Index,
        children: SamplingTaskRoutes,
        mata: {title: '抽样任务'}
    }, {
        path: '/sampling_list',
        component: Index,
        children: SamplingListRoutes,
        mata: {title: '抽样单管理'}
    }, {
        path: '/history_sampling',
        component: Index,
        children: HistorySamplingRoutes,
        mata: {title: '历史抽样单'}
    }

]
