import dateformat from 'dateformat';
import global from '../api/config';

export default {
    install(Vue) {
        /**
         * 日期格式化
         * https://www.npmjs.com/package/dateformat
         */
        Vue.prototype.$dateformat = function (date, format) {
            return date ? dateformat(date, format) : ''
        };

        /**
         * 重置数据
         * */
        Vue.prototype.$resetFields = function (formObj) {
            let newFormObj = {}
            for (let key in formObj) {
                newFormObj[key] = ''
            }
            return newFormObj;
        };

        /**
         * 序列化formObj  只返回有值的
         * @param formObj
         */
        Vue.prototype.$serializeForm = function (formObj) {
            const newFormObj = {}
            for (const key in formObj) {
                // 不为空的时候传值
                if (formObj[key] !== '') {
                    newFormObj[key] = formObj[key]
                }
            }
            return newFormObj
        }

        /**
         * 将经纬度转化为度分秒的格式
         * ****/
        Vue.prototype.$changeToDFM = function (du, type) {
            let duStr = du.toString()
            const arr1 = duStr.split(".");
            const d = arr1[0];
            let tp = "0." + arr1[1]
            tp = String(tp * 60); //这里进行了强制类型转换
            const arr2 = tp.split(".");
            const f = arr2[0];
            tp = "0." + arr2[1];
            tp = tp * 60;
            let mStr = tp.toString();
            const arr3 = mStr.split(".")
            const subStr = arr3[1].substring(0, 2)
            const m = arr3[0] + "." + subStr;
            const dfm = d + "°" + f + "'" + m + "\"" + type;
            return dfm;
        };

        /**
         * 全局的配置
         * @type
         */
        Vue.prototype.$global = global
    },
}
