import Index from '@/page/Index'
import Home from '@/page/Home'
import Login from '@/page/Login'
import ForgetPwd from '@/page/ForgetPwd'
import Class from '@/page/Class'
import ScanBar from '@/page/ScanBar'

import RegisterRoutes from './register-routes'
import MineRoutes from './mine-routes'
import SamplingCodeRoutes from './sampling-code-routes'


import DebugComponent from '@/components/DebugComponent.vue'

export default [
    {
        path: '/', component: Index, redirect: '/home', children: [
            {
                path: "/home",
                name: "home",
                component: Home,
                meta: {title: "温湿度", leftArrow: false},
            },
            {
                path: "/login",
                name: "login",
                component: Login,
                meta: {title: "登录", hideNavBar: true},
            }, {
                path: "/forget_pwd",
                name: "forgetPwd",
                component: ForgetPwd,
                meta: {title: "找回密码", hideNavBar: true},
            }, {
                path: "/debug",
                name: "debug",
                component: DebugComponent,
                meta: {title: "调试组件页面", hideNavBar: true},
            },
            {
                path: '/class',
                name: 'class',
                component: Class,
                meta: {title: '分类查询'}
            },{
                path: '/scan_bar',
                name: 'scan',
                component: ScanBar,
                meta: {title: '分类查询',hideNavBar: true}
            },
        ],
    }, {
        path: '/mine',
        component: Index,
        children: MineRoutes,
        mata: {title: '个人中心'}
    }, {
        path: '/register',
        component: Index,
        children: RegisterRoutes,
        mata: {title: '温湿度登记'}
    }, {
        path: '/sampling_code',
        component: Index,
        children: SamplingCodeRoutes,
        mata: {title: '抽样条码'}
    },

]
